package gov.va.genisis2.ts.dto;

import java.io.Serializable;

public class MetaRelationshipDTO implements Serializable, Comparable<MetaRelationshipDTO> {

	private static final long serialVersionUID = 4058000321634502780L;

	private String relationshipName;
	private String relationshipUri;
	private String relatedConcept;
	private String relatedConceptUri;
	private Boolean isMvpPredicate;

	/**
	 * @return the relationshipName
	 */
	public String getRelationshipName() {
		return relationshipName;
	}

	/**
	 * @param relationshipName
	 *            the relationshipName to set
	 */
	public void setRelationshipName(String relationshipName) {
		this.relationshipName = relationshipName;
	}

	/**
	 * @return the relationshipUri
	 */
	public String getRelationshipUri() {
		return relationshipUri;
	}

	/**
	 * @param relationshipUri
	 *            the relationshipUri to set
	 */
	public void setRelationshipUri(String relationshipUri) {
		this.relationshipUri = relationshipUri;
	}

	/**
	 * @return the relatedConcept
	 */
	public String getRelatedConcept() {
		return relatedConcept;
	}

	/**
	 * @param relatedConcept
	 *            the relatedConcept to set
	 */
	public void setRelatedConcept(String relatedConcept) {
		this.relatedConcept = relatedConcept;
	}

	/**
	 * @return the relatedConceptUri
	 */
	public String getRelatedConceptUri() {
		return relatedConceptUri;
	}

	/**
	 * @param relatedConceptUri
	 *            the relatedConceptUri to set
	 */
	public void setRelatedConceptUri(String relatedConceptUri) {
		this.relatedConceptUri = relatedConceptUri;
	}

	/**
	 * @return the isMvpPredicate
	 */
	public Boolean getIsMvpPredicate() {
		return isMvpPredicate;
	}

	/**
	 * @param isMvpPredicate
	 *            the isMvpPredicate to set
	 */
	public void setIsMvpPredicate(Boolean isMvpPredicate) {
		this.isMvpPredicate = isMvpPredicate;
	}

	/**
	 * sort relationships on 'relationshipName' attribute
	 */
	public int compareTo(MetaRelationshipDTO object) {
		String localRelationshipName = (null != object) ? object.getRelationshipName() : null;
		return (null != localRelationshipName) ? this.relationshipName.compareToIgnoreCase(localRelationshipName) : -1;
	}
}
